#version 120

#define MAX_COLOR_RANGE 45.0
/*
Read Mine and Chocapic13's terms of mofification/sharing before changing something below please!
ﯼᵵᴀᵶᵶᴬﺤ super Shaders (ﯼ✗∃), derived from Chocapic13 v4 Beta 4.8
Place two leading Slashes in front of the following '#define' lines in order to disable an option.
*/

//to increase shadow draw distance, edit shadowDistance and SHADOWHPL below. Both should be equal. Needs decimal point.
//disabling is done by adding "//" to the beginning of a line.

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

//----------Shadows----------//
	const int shadowMapResolution = 4096;		//shadowmap resolution
	const float shadowDistance = 128.0f;		//draw distance of shadows
	#define SHADOW_DARKNESS 0.20				//shadow darkness levels, lower values mean darker shadows, see .vsh for colors /0.25 is default
	#define HQ_SHADOW_FILTER	
	//#define SHADOW_FILTER						//smooth shadows
//----------End of Shadows----------//

//----------Lighting----------//
	#define DYNAMIC_HANDLIGHT
	
	#define SUNLIGHTAMOUNT 4.4				//change sunlight strength , see .vsh for colors. /1.7 is default
	
	#define TORCH_COLOR_LIGHTING 0.6,0.4,0.15 	//Torch Color RGB - Red, Green, Blue / vec3(0.6,0.32,0.1) is default
		#define TORCH_ATTEN 2.2					//how much the torch light will be attenuated (decrease if you want the torches to cover a bigger area))/3.0 is default
		#define TORCH_INTENSITY 5.0				//torch light intensity /2.6 is default
	
	//Minecraft lightmap (used for sky)
	#define ATTENUATION 3.0
	#define MIN_LIGHT 0.003
	
	#define Pseudo_hdr
	#define NIGHT_EXPOSURE 1.2f
//----------End of Lighting----------//

//----------Visual----------//
#define GODRAYS
		const float density = 0.55;			
		const int NUM_SAMPLES = 5;				//increase this for better quality at the cost of performance /5 is default
		const float grnoise = 0.0;			//amount of noise /0.012 is default
	
#define SSAO								//works but is turned off by default due to performance cost
		//SSAO constants
		const int nbdir = 5;					//the two numbers here affect the number of sample used. Increase for better quality at the cost of performance /6 and 6 is default
		const float sampledir = 8;	
		const float ssaorad = 0.7;				//radius of ssao shadows /1.0 is default
	
	//#define CELSHADING
		#define BORDER 1.0

	const float	sunPathRotation	= -37.0f;		//determines sun/moon inclination /-40.0 is default - 0.0 is normal rotation
//----------End of Visual----------//

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES



const float 	wetnessHalflife 		= 70.0f;
const float 	drynessHalflife 		= 70.0f;
const int 		R8						= 0;
const int 		gdepthFormat 			= R8;
const bool 		shadowHardwareFiltering = true;

const float 	shadowIntervalSize 		= 4.0f;
const int 		noiseTextureResolution  = 32;
#define SHADOW_MAP_BIAS 0.80

varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;

varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 ambient_color;

varying float handItemLight;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D gcolor;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gnormal;
uniform sampler2D gaux3;
uniform sampler2DShadow shadow;
uniform sampler2D gaux1;
uniform sampler2D noisetex;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;

uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform float centerDepthSmooth;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform int fogMode;

float cdist(vec2 coord){
    return distance(coord,vec2(0.5))*2.0;
}

vec3 convertScreenSpaceToWorldSpace(vec2 co, float depth) {
    vec4 fragposition = gbufferProjectionInverse * vec4(vec3(co, depth) * 2.0 - 1.0, 1.0);
    fragposition /= fragposition.w;
    return fragposition.xyz;
}

vec3 convertCameraSpaceToScreenSpace(vec3 cameraSpace) {
    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;
    return screenSpace;
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float edepth(vec2 coord) {
	return texture2D(depthtex0,coord).z;
}

vec2 texel = vec2(1.0/viewWidth,1.0/viewHeight);
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;

vec3 aux = texture2D(gaux1, texcoord.st).rgb;
vec3 sunPos = sunPosition;
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0f - 1.0f;

float pixeldepth = texture2D(depthtex0,texcoord.xy).x;
float handlight = handItemLight;

float torch_lightmap = pow(aux.r,1.0);


float sky_lightmap = pow(aux.r,ATTENUATION);

float iswet = wetness*pow(sky_lightmap,5.0)*sqrt(0.5+max(dot(normal,normalize(upPosition)),0.0));
	
vec3 specular = texture2D(gaux3,texcoord.xy).rgb;
float specmap = specular.r*(1.0-specular.b)+specular.g*iswet+specular.b*0.85*(1.0-specular.r);
	
//poisson distribution for shadow sampling		
const vec2 circle_offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);
									

									

float ctorspec(vec3 ppos, vec3 lvector, vec3 normal,float rough,float fpow) {
	//half vector
	vec3 pos = -normalize(ppos);
	vec3 cHalf = normalize(lvector + pos);
	
	// beckman's distribution function D
	float normalDotHalf = dot(normal, cHalf);
	float normalDotHalf2 = normalDotHalf * normalDotHalf;
	
	float roughness2 = rough;
	float exponent = -(1.0 - normalDotHalf2) / (normalDotHalf2 * roughness2);
	float e = 2.71828182846;
	float D = pow(e, exponent) / (roughness2 * normalDotHalf2 * normalDotHalf2);
	
	// fresnel term F
	float normalDotEye = dot(normal, pos);
	float F = pow(1.0 - normalDotEye, fpow);

	// self shadowing term G
	float normalDotLight = dot(normal, lvector);
	float X = 2.0 * normalDotHalf / dot(pos, cHalf);
	float G = min(1.0, min(X * normalDotLight, X * normalDotEye));
	float pi = 3.1415927;
	float CookTorrance = (D*G)/acos(normalDotEye);
	
	return clamp(CookTorrance/pi,0.0,1.0);
}

float Blinn_Phong(vec3 ppos, vec3 lvector, vec3 normal,float fpow, float gloss, float visibility)  {
	/*
	vec3 npos = normalize(ppos);
	vec3 halfVector = normalize(lightVector - npos);
	float specular 	= max(0.0f, dot(halfVector, normal));
	specular = pow(specular,60.0);
	return clamp(specular,0.0,1.0);
	*/
	vec3 lightDir = vec3(lvector);
	
	vec3 surfaceNormal = normal;
	float cosAngIncidence = dot(surfaceNormal, lightDir);
	cosAngIncidence = clamp(cosAngIncidence, 0.0, 1.0);
	
	vec3 viewDirection = normalize(-ppos);
	
	vec3 halfAngle = normalize(lightDir + viewDirection);
	float blinnTerm = dot(surfaceNormal, halfAngle);
	
	float normalDotEye = dot(normal, normalize(ppos));
	float fresnel = clamp(pow(1.0 + normalDotEye, 5.0),0.0,1.0);
	fresnel = fresnel*0.85 + 0.15 * (1.0-fresnel);
	float pi = 3.1415927;
	float n =  pow(2.0,gloss*10.0);
	return (pow(blinnTerm, n )*((n+8.0)/(8*pi)))*visibility;
}

float diffuseorennayar(vec3 pos, vec3 lvector, vec3 normal, float spec, float roughness) {
	
vec3 eyeDir = normalize(pos);

float roughness2 = roughness * roughness;
float PI = 3.1415927;
    
    // calculate intermediary values
    float NdotL = dot(normal, lvector);
    float NdotV = dot(normal, eyeDir); 

    float angleVN = acos(NdotV);
    float angleLN = acos(NdotL);
    
    float alpha = max(angleVN, angleLN);
    float beta = min(angleVN, angleLN);

    
    float roughnessSquared = roughness * roughness;
    float roughnessSquared9 = (roughnessSquared / (roughnessSquared + 0.09));
    
    // calculate C1, C2 and C3
    float C1 = 1.0 - 0.5 * (roughnessSquared / (roughnessSquared + 0.33));
    float C2 = 0.45 * roughnessSquared9;
    

        C2 *= sin(alpha);
 
    float powValue = (4.0 * alpha * beta) / (PI * PI);
    float C3  = 0.125 * roughnessSquared9 * powValue * powValue;
 
    // put it all together
    float L1 = max(0.0, NdotL) * (C1 +(C2*max(0.0,cos(angleLN-angleVN))*sin(alpha)));
    
	return clamp((L1),0.0,1.0);
}

float getnoise(vec2 pos) {
	return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));
}

float interpolate(vec3 truepos,float center,vec3 poscenter,float value2,vec3 pos2,float value3,vec3 pos3,float value4,vec3 pos4,float value5,vec3 pos5) {
	/*
	float mix1 = mix(center,value2,1.0-length(truepos-pos2));
	float mix2 = mix(mix1,value3,1.0-length(truepos-pos3));
	float mix3 = mix(mix2,value4,1.0-length(truepos-pos4));
	return mix(mix3,value5,1.0-length(truepos-pos5));
	*/
	return center*(1.0-distance(truepos,poscenter))+value2*(1.0-distance(truepos,pos2))+value3*(1.0-distance(truepos,pos3))+value4*(1.0-distance(truepos,pos4))+value5*(1.0-distance(truepos,pos5));
}

#ifdef CELSHADING
vec3 celshade(vec3 clrr) {
	//edge detect
	float d = edepth(texcoord.xy);
	float dtresh = 1/(far-near)/5000.0;	
	vec4 dc = vec4(d,d,d,d);
	vec4 sa;
	vec4 sb;
	sa.x = edepth(texcoord.xy + vec2(-pw,-ph)*BORDER);
	sa.y = edepth(texcoord.xy + vec2(pw,-ph)*BORDER);
	sa.z = edepth(texcoord.xy + vec2(-pw,0.0)*BORDER);
	sa.w = edepth(texcoord.xy + vec2(0.0,ph)*BORDER);
	
	//opposite side samples
	sb.x = edepth(texcoord.xy + vec2(pw,ph)*BORDER);
	sb.y = edepth(texcoord.xy + vec2(-pw,ph)*BORDER);
	sb.z = edepth(texcoord.xy + vec2(pw,0.0)*BORDER);
	sb.w = edepth(texcoord.xy + vec2(0.0,-ph)*BORDER);
	
	vec4 dd = abs(2.0* dc - sa - sb) - dtresh;
	dd = vec4(step(dd.x,0.0),step(dd.y,0.0),step(dd.z,0.0),step(dd.w,0.0));
	
	float e = clamp(dot(dd,vec4(0.25f,0.25f,0.25f,0.25f)),0.0,1.0);
	return clrr*e;
}
#endif


float subSurfaceScattering(vec3 pos, float N) {

return pow(max(dot(lightVector,normalize(pos)),0.0),N)*(N+1)/6.28;

}

vec3 getSkyColor(vec3 fposition) {
//sky gradient
/*----------*/
vec3 sky_color = pow(ambient_color,vec3(4.2))*2.0;
vec3 nsunlight = normalize(pow(sunlight,vec3(2.2)));
vec3 sVector = normalize(fposition);
vec3 upVector = normalize(upPosition);

sky_color = normalize(mix(sky_color,vec3(1.2)*length(ambient_color),rainStrength)); //normalize colors in order to don't change luminance


float Lz = 1.0;
float cosT = dot(sVector,upVector); //T=S-Y  
float absCosT = abs(cosT);
float cosS = dot(sunVec,upVector);
float S = acos(cosS);				//S=Y+T	-> cos(Y+T)=cos(S) -> cos(Y)*cos(T) - sin(Y)*sin(T) = cos(S)
float cosY = dot(sunVec,sVector);
float Y = acos(cosY);				//Y=S-T

float a = -0.7;
float b = -0.15;
float c = 15.0;
float d = -1.0;
float e = 0.3;

//sun sky color
float L =  (1+a*exp(b/(absCosT+0.01)))*(1+c*exp(d*Y)+e*cosY*cosY); 
L = pow(L,1.0-rainStrength*0.8)*(1.0-rainStrength*0.2); //modulate intensity when raining
vec3 skyColorSun = mix(sky_color, nsunlight,1-exp(-0.1*L*(1-rainStrength*0.8)))*L ; //affect color based on luminance (0% physically accurate)
skyColorSun *= sunVisibility;


//moon sky color
float McosS = dot(moonVec,upVector);
float MS = acos(McosS);
float McosY = dot(moonVec,sVector);
float MY = acos(McosY);

float L2 =  (1+a*exp(b/(absCosT+0.01)))*(1+c*exp(d*MY)+e*McosY*McosY);
L2 = pow(L2,1.0-rainStrength*0.8)*(1.0-rainStrength*0.2); //modulate intensity when raining
vec3 skyColormoon = mix(moonlight,normalize(vec3(0.25,0.3,0.4))*length(moonlight),rainStrength)*L2*0.4 ; //affect color based on luminance (0% physically accurate)
skyColormoon *= moonVisibility;


sky_color = skyColormoon+skyColorSun;
//sky_color = vec3(Lc);
/*----------*/


return sky_color;
}


vec3 drawCloud(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = dot(moonVec,sVector);
float cosY = dot(sunVec,sVector);
float MY = acos(McosY);


//cloud generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(48.0/(wVector.y));



//float canHit = length(intersection)-length(tpos);

	vec2 wind = vec2(frameTimeCounter*(cos(frameTimeCounter/1000.0)+0.5),frameTimeCounter*(sin(frameTimeCounter/1000.0)+0.5))*0.33;
	
	
	vec3 wpos = tpos.xyz+cameraPosition;
	intersection.xz = intersection.xz + 2.0*cosT*intersection.xz;		//curve the cloud pattern, because sky is not 100% plane in reality
	vec2 coord = (intersection.xz+wind)/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/6.0)).x;
	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
	noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
	noise += texture2D(noisetex,fract(coord.xy*8.0)).x/16.0;
	noise += texture2D(noisetex,fract(coord.xy*16.0)).x/32.0;
	noise += texture2D(noisetex,fract(coord.xy*32.0)).x/64.0;
	noise += texture2D(noisetex,fract(coord.xy*64.0)).x/128.0;
	noise += texture2D(noisetex,fract(coord.xy*128.0)).x/256.0;
	
	float coverageVariance = (sin(-intersection.x*0.025+frameTimeCounter*0.2)+cos(intersection.z*0.02-frameTimeCounter*0.08))*(1+sin(frameTimeCounter*0.016))*1.0;
	vec2 tc = vec2(cos(coord.x*0.25-frameTimeCounter*0.006),cos(coord.y*0.25+frameTimeCounter*0.006));
	coverageVariance = (texture2D(noisetex,tc).x*2.0-1.0)*0.1;
	float cl = max(noise-1.1-coverageVariance+rainStrength*0.6,0.0);

 
      float cloud = (1.0 - (pow(0.2-rainStrength*0.15,cl)))*max(cosT,0.0);
	  float N = 12.0;
vec3 cloud_color = moonlight*4*4.0*moonVisibility*(1-rainStrength*0.8) + sunlight*4.0*sunVisibility*(1-rainStrength*0.8) + ambient_color*5.0 + sunlight*48.0*pow(max(cosY,0.0),N)*(N+1)/6.28 * (cloud*0.5+0.5) * (1-rainStrength*0.8)*sunVisibility + moonlight*48.0*pow(max(McosY,0.0),N)*(N+1)/6.28 * (cloud*0.5+0.5) * (1-rainStrength*0.8)*moonVisibility ;	//coloring clouds
/*----------*/
return mix(color,cloud_color,cloud);  //mix up sky color and clouds

}


float PosDot(vec3 v1,vec3 v2) {
return max(dot(v1,v2),0.0);
}

float waterH(vec3 posxz) {

float wave = 0.0;


float factor = 1.0;
float amplitude = 0.2;
float speed = 4.0;
float size = 0.2;

float px = posxz.x/50.0 + 250.0;
float py = posxz.z/50.0  + 250.0;

float fpx = abs(fract(px*20.0)-0.5)*2.0;
float fpy = abs(fract(py*20.0)-0.5)*2.0;

float d = length(vec2(fpx,fpy));

for (int i = 1; i < 8; i++) {
wave -= d*factor*cos( (1/factor)*px*py*size + 1.0*frameTimeCounter*speed);
factor /= 2;
}

factor = 1.0;
px = -posxz.x/50.0 + 250.0;
py = -posxz.z/150.0 - 250.0;

fpx = abs(fract(px*20.0)-0.5)*2.0;
fpy = abs(fract(py*20.0)-0.5)*2.0;

d = length(vec2(fpx,fpy));
float wave2 = 0.0;
for (int i = 1; i < 8; i++) {
wave2 -= d*factor*cos( (1/factor)*px*py*size + 1.0*frameTimeCounter*speed);
factor /= 2;
}

return amplitude*wave2+amplitude*wave;
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
	
#ifndef DYNAMIC_HANDLIGHT
		handlight = 0.0;
#endif

	//unpack material flags
	float land = float(aux.g > 0.04);
	float iswater = float(aux.g > 0.04 && aux.g < 0.07);
	float translucent = float(aux.g > 0.3 && aux.g < 0.5);
	float hand = float(aux.g > 0.75 && aux.g < 0.85);
	float emissive = float(aux.g > 0.58 && aux.g < 0.62);
	float shading = 0.0f;
	float spec = 0.0;
	
	float roughness = mix(1.0-specular.b,0.005,iswater);
	if (specular.r+specular.g+specular.b < 1.0/255.0 && iswater < 0.09) roughness = 0.99;
	
	float fresnel_pow = pow(roughness,1.25+iswet*0.75)*5.0;
	if (iswater > 0.9) fresnel_pow=5.0;
	
	vec3 color = texture2D(gcolor, texcoord.st).rgb;
	color = pow(color,vec3(2.2));
	
	float NdotL = dot(lightVector,normal);

	
	vec4 fragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * pixeldepth - 1.0f, 1.0f);
	fragposition /= fragposition.w;
	
		vec4 worldposition = vec4(0.0);
		vec4 worldpositionraw = vec4(0.0);
		worldposition = gbufferModelViewInverse * fragposition;	
		float xzDistanceSquared = worldposition.x * worldposition.x + worldposition.z * worldposition.z;
		float yDistanceSquared  = worldposition.y * worldposition.y;
		worldpositionraw = worldposition;
		
		
	float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13500.0)/300.0,0.0,1.0) + clamp((time-22500.0)/300.0,0.0,1.0)-clamp((time-23400.0)/300.0,0.0,1.0));	//fading between sun/moon shadows
	float night = clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-23000.0)/200.0,0.0,1.0);
	float day = clamp((time-22000.0)/300.0,0.0,1.0)-clamp((time-13000.0)/200.0,0.0,1.0);
	
	
	if (iswater > 0.9) {
	
	vec3 posxz = worldposition.xyz;
	posxz.x += sin(posxz.z+frameTimeCounter)*0.4;
	posxz.z += cos(posxz.x+frameTimeCounter*0.5)*0.4;
	
	float deltaPos = 0.4;
	float h0 = waterH(posxz);
	float h1 = waterH(posxz + vec3(deltaPos,0.0,0.0));
	float h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0));
	float h3 = waterH(posxz + vec3(0.0,0.0,deltaPos));
	float h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos));
	
	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

	
	float refMult = 0.0025-dot(normal,normalize(fragposition).xyz)*0.0015;
	
	vec3 refract = normalize(vec3(xDelta,yDelta,1.0-xDelta*xDelta-yDelta*yDelta));
	vec4 rA = texture2D(gcolor, texcoord.st + refract.xy*refMult);
	rA.rgb = pow(rA.rgb,vec3(2.2));
	vec4 rB = texture2D(gcolor, texcoord.st);
	rB.rgb = pow(rB.rgb,vec3(2.2));
	float mask = texture2D(gaux1, texcoord.st + refract.xy*refMult).g;
	mask =  float(mask > 0.04 && mask < 0.07);
	color = rA.rgb*mask + rB.rgb*(1-mask);
	}
	
	
	if (land > 0.9 && isEyeInWater < 0.1) {
		float dist = length(fragposition.xyz);
		float distof = clamp(1.0-dist/shadowDistance,0.0,1.0);
		float distof2 = clamp(1.0-pow(dist/(shadowDistance*0.75),2.0),0.0,1.0);
		//float shadow_fade = clamp(distof*12.0,0.0,1.0);
		float shadow_fade = sqrt(clamp(1.0 - xzDistanceSquared / (shadowDistance*shadowDistance*1.0), 0.0, 1.0) * clamp(1.0 - yDistanceSquared / (shadowDistance*shadowDistance*1.0), 0.0, 1.0));

		
		/*--reprojecting into shadow space --*/

		worldposition = shadowModelView * worldposition;
		float comparedepth = -worldposition.z;
		worldposition = shadowProjection * worldposition;
		worldposition /= worldposition.w;
		float distb = sqrt(worldposition.x * worldposition.x + worldposition.y * worldposition.y);
		float distortFactor = (1.0f - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
		worldposition.xy *= 1.0f / distortFactor;
		worldposition = worldposition * 0.5f + 0.5f;
		/*---------------------------------*/
		
		
		float step = 3.0/shadowMapResolution*(1.0+rainStrength*5.0);
		//shadow_fade = 1.0-clamp((max(abs(worldposition.x-0.5),abs(worldposition.y-0.5))*2.0-0.9),0.0,0.1)*10.0;
		
		float NdotL = dot(normal, lightVector);
		float diffthresh = mix(pow(distortFactor*1.2,2.0)*(0.38/far)*(tan(acos(abs(NdotL)))) + (0.12/far), (0.28/far),(translucent+iswater));
		
		if (comparedepth > 0.0f &&	worldposition.s < 1.0f && worldposition.s > 0.0f && worldposition.t < 1.0f && worldposition.t > 0.0f ) {
			if ((NdotL < 0.0 && translucent < 0.1) || (sky_lightmap < 0.01 && eyeBrightness.y < 2)) {
					shading = 0.0;
				}
			
			else {
			#ifdef HQ_SHADOW_FILTER
				step = 2.0/shadowMapResolution*(1.0+rainStrength*5.0);
				//diffthresh = 0.0018f * diffthresh * (0.5+(1.0-NdotL)*5.0*(1.0-translucent));
				float weight;
				float totalweight = 0.0;
				float sigma = 0.25;
				float A = 1.0/sqrt(2.0*3.14159265359*sigma);
				
				for(int i = 0; i < 25; i++){
					float dist = length(circle_offsets[i]);
					float weight = A*exp(-(dist*dist)/(2.0*sigma));
					shading += shadow2D(shadow,vec3(worldposition.st + circle_offsets[i]*step, worldposition.z-diffthresh*(2.0-weight))).x*weight;
					totalweight += weight;
				}
			
			shading /= totalweight;
			#endif
			
			step = 1.0/shadowMapResolution*(1.0+rainStrength*5.0);
			
			#ifdef SHADOW_FILTER
				shading = shadow2D(shadow,vec3(worldposition.st, worldposition.z-diffthresh)).x;
				shading += shadow2D(shadow,vec3(worldposition.st + vec2(step,step), worldposition.z-diffthresh)).x;
				shading += shadow2D(shadow,vec3(worldposition.st + vec2(step,-step), worldposition.z-diffthresh)).x;
				shading += shadow2D(shadow,vec3(worldposition.st + vec2(-step,-step), worldposition.z-diffthresh)).x;
				shading += shadow2D(shadow,vec3(worldposition.st + vec2(-step,step), worldposition.z-diffthresh)).x;
				shading = shading/5.0;
			#endif
			
			#ifndef SHADOW_FILTER
				#ifndef HQ_SHADOW_FILTER
				shading = shadow2D(shadow,vec3(worldposition.st, worldposition.z-diffthresh)).x;
				#endif
			#endif 
			}
		}
		
		else shading = 1.0;
		
		float ao = 1.0;
		
	#ifdef SSAO
		if (land > 0.9 && iswater < 0.9 && hand < 0.9) {
			vec3 norm = texture2D(gnormal,texcoord.xy).rgb*2.0-1.0;
			vec3 projpos = convertScreenSpaceToWorldSpace(texcoord.xy,pixeldepth); 
			float progress = 0.0;
			ao = 0.0;
			float projrad = clamp(distance(convertCameraSpaceToScreenSpace(projpos + vec3(ssaorad,ssaorad,ssaorad)).xy,texcoord.xy),0.05,0.1);
			
			for (int i = 1; i < nbdir; i++) {
				for (int j = 1; j < sampledir; j++) {
					vec2 samplecoord = vec2(cos(progress),sin(progress))*(j/sampledir)*projrad + texcoord.xy;
					float sample = texture2D(depthtex0,samplecoord).x;
					vec3 sprojpos = convertScreenSpaceToWorldSpace(samplecoord,sample);
					float angle = min(1.0-sqrt(dot(norm,normalize(sprojpos-projpos))),1.0);
					float dist = pow(min(abs(length(sprojpos)-length(projpos)),ssaorad)/ssaorad,2.0);
					float temp = min(dist+angle,1.0);
					ao += temp;
					progress += (1.0-temp)/nbdir*3.14;
				}
				progress = i*(6.28/nbdir);
			}
			ao /= (nbdir-1)*(sampledir-1);
			ao = pow(ao,2.2);
		}
	#endif
		vec3 npos = normalize(fragposition.xyz);

		float diffuse = max(dot(lightVector,normal),0.0);
		
		diffuse = mix(diffuse,1.0,translucent*0.8*shadow_fade);
		float sss = subSurfaceScattering(fragposition.xyz,30.0)*SUNLIGHTAMOUNT*2.0;
		sss = (mix(0.0,sss,max(shadow_fade-0.1,0.0)*1.111)*0.5+0.5)*translucent;
		
		float handLight = (handlight*8.0)/pow(1.0+length(fragposition.xyz/2.0),2.0)*sqrt(dot(normalize(fragposition.xyz), -normal)*0.5+0.5);
		
	//Apply different lightmaps to image
		vec3 light_col =  mix(sunlight,moonlight,moonVisibility);
		vec3 Sunlight_lightmap = mix(light_col,vec3(0.5),rainStrength*0.9)*mix(max(sky_lightmap-rainStrength*0.95,0.0),shading*(1.0-rainStrength*0.95),1.0)*SUNLIGHTAMOUNT *diffuse*transition_fading ;

		
		float visibility = sky_lightmap;
		float NdotUp = dot(normal,normalize(upPosition));
		float bouncefactor = sqrt(NdotUp*0.33+0.68);
		float cfBounce = PosDot(normalize(-sunPosition),normal)*0.5 + (1-bouncefactor)*0.5;
		float cfBounce2 = PosDot(normalize(sunPosition),normal)*0.2 + (1-bouncefactor)*0.2 + 0.6;
						
		vec3 aLightNormal = vec3(0.0);
		vec3 a_light =  ambient_color;
		
		vec3 emissive = vec3(2.0)*color.r*color.r*color.r*luma(color)*(emissive+handlight*hand)*(2.8-min(length(ambient_color)/sqrt(3.0),eyeBrightnessSmooth.y/240.0*1.7));

		vec3 bounceSunlight = cfBounce*sunlight*sunVisibility*sky_lightmap*SHADOW_DARKNESS*0.5 * (1-rainStrength*0.9);
		vec3 bounceMoonlight = cfBounce2*moonlight*moonVisibility*1.5* (1-rainStrength*0.9);
		
		////////New Dynamic Tone Mapping///////	
	
//Skylight Factor
	float Skylight_Exposure = eyeBrightnessSmooth.y / 16.0;
	
		  Skylight_Exposure = min(Skylight_Exposure, 16.0) / 16.0;
		  

#ifdef Pseudo_hdr
	
	//Pseudo_hdr
	Skylight_Exposure = pow(Skylight_Exposure, 7.0);
	Skylight_Exposure *= mix(1.0f, NIGHT_EXPOSURE, night);
	color.rgb /= Skylight_Exposure+night/3 * 1.175 + 0.40;
	
	color.rgb *= 25.0;
	
	//Colour Properties
		float Tonemap_Contrast 		= 1.7;
		float Tonemap_Saturation 	= 1.4; 
		float Tonemap_Decay			= 800.0;
		float Tonemap_Curve			= 65.0;
		

	
	color.rgb += 0.001;
	
	vec3 colorN = normalize(color.rgb);
	
	vec3 clrfr = color.rgb/colorN.rgb;
	     clrfr = pow(clrfr.rgb, vec3(Tonemap_Contrast));
		 
	colorN.rgb = pow(colorN.rgb, vec3(Tonemap_Saturation));
	
	color.rgb = clrfr.rgb * colorN.rgb;

	color.rgb = (color.rgb * (1.0 + color.rgb/Tonemap_Decay))/(color.rgb + Tonemap_Curve);

#endif	
		
		
	////////New Torch System///////	
		
		float TorchBrightnessDay     = 0.00001f*day*torch_lightmap+SHADOW_DARKNESS+rainStrength*5.18;
		float TorchRangeDay          = 0.000001f*day*torch_lightmap+SHADOW_DARKNESS+rainStrength*3.18;
	
		float TorchBrightnessNight   = 6.8*night*torch_lightmap;
		float TorchRangeNight        = 3.5*night*torch_lightmap;
		
	
		float TorchtBrightness_shadow = 0.4/torch_lightmap+day+night;
		float TorchRange_shadow      = 0.2/torch_lightmap+day+night;
	
		float TorchHandlightDay      = 99.0000001*day*torch_lightmap;
		float TorchHandlightNight    = 5.00007*night*torch_lightmap;
		float TorchHandlight_shadow  = 0.009/torch_lightmap;

	
	
	
		float Torch_brightness = TorchBrightnessDay + TorchtBrightness_shadow + TorchBrightnessNight;
		float Torch_range = TorchRangeDay + TorchRange_shadow + TorchRangeNight;
		float Torch_handlight = TorchHandlightDay + TorchHandlight_shadow + TorchHandlightNight;
	
		float torch_lightmap = pow(aux.b,Torch_range)*Torch_brightness;
	
		vec3 torchcolor = vec3(0.8,0.30,0.1);
	
		
		
		vec3 sky_light = SHADOW_DARKNESS*a_light*ao * visibility;
		vec3 Torchlight_lightmap = (torch_lightmap + handLight) *  torchcolor ;
		vec3 color_sunlight = Sunlight_lightmap;
		vec3 color_torchlight = Torchlight_lightmap;
		

		
		
	//Add all light elements together
		color = ( bounceSunlight+ bounceMoonlight*sky_lightmap*SHADOW_DARKNESS + sky_light+ MIN_LIGHT*ao + Sunlight_lightmap + color_torchlight*ao  +  sss * light_col * shading *(1.0-rainStrength*0.9)*transition_fading + emissive)*color;
		float gfactor = mix(roughness+0.1,1.0,iswater);
		

		spec = Blinn_Phong(fragposition.xyz,lightVector,normal,fresnel_pow,gfactor,shading*diffuse) *land * (1.0-isEyeInWater)*transition_fading;

	//color = vec3(ao);
	}
	
	else if (isEyeInWater < 0.1 && (aux.g < 0.02) ){

	color = getSkyColor(fragposition.xyz)+pow(texture2D(gcolor,texcoord.xy).rgb,vec3(2.2))*(1-sunVisibility)*15.0*sqrt(max(dot(upVec,normalize(fragposition.xyz)),0.0)) ;

	}
	
	if (land < 0.1) {
	color.rgb = drawCloud(fragposition.xyz,color.rgb);

	}
	if(aux.g > 0.02 && aux.g < 0.04) color *= 5.0;

	
/* DRAWBUFFERS:31 */
float gr = 0.0;
#ifdef GODRAYS
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos1 = tpos.xy/tpos.z;
	vec2 lightPos = pos1*0.5+0.5;
	
	float truepos = pow(clamp(dot(-sunVec,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.5);		//temporary fix that check if the sun/moon position is correct
	if (truepos > 0.01 && sunVisibility > 0.01) {	
		vec2 deltaTextCoord = vec2( texcoord.st - lightPos.xy );
		vec2 textCoord = texcoord.st;
		deltaTextCoord *= 1.0 /  float(NUM_SAMPLES) * density;
		float avgdecay = 0.0;
		float distx = abs(texcoord.x*aspectRatio-lightPos.x*aspectRatio);
		float disty = abs(texcoord.y-lightPos.y);
		float fallof = 1.0;
		float noise = getnoise(textCoord);
		
		for(int i=0; i < NUM_SAMPLES ; i++) {			
			textCoord -= deltaTextCoord;
			
			fallof *= 0.8;
			float sample = step(texture2D(gaux1, textCoord+ deltaTextCoord*noise*grnoise).g,0.01);
			gr += sample*fallof;
		}
	}
	else {
	tpos = vec4(-sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	pos1 = tpos.xy/tpos.z;
	lightPos = pos1*0.5+0.5;
	truepos = pow(clamp(dot(-moonVec,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.5);
	
		if (truepos > 0.01 && moonVisibility > 0.01) {
		vec2 deltaTextCoord = vec2( texcoord.st - lightPos.xy );
		vec2 textCoord = texcoord.st;
		deltaTextCoord *= 1.0 /  float(NUM_SAMPLES) * density;
		float avgdecay = 0.0;
		float distx = abs(texcoord.x*aspectRatio-lightPos.x*aspectRatio);
		float disty = abs(texcoord.y-lightPos.y);
		float fallof = 1.0;
		float noise = getnoise(textCoord);
		
		for(int i=0; i < NUM_SAMPLES ; i++) {			
			textCoord -= deltaTextCoord;
			
			fallof *= 0.8;
			float sample = step(texture2D(gaux1, textCoord+ deltaTextCoord*noise*grnoise).g,0.01);
			gr += sample*fallof;
		}
	}
	}
#endif
	
#ifdef CELSHADING
	if (iswater < 0.9) color = celshade(color);
#endif
	
	color = clamp(pow(color/MAX_COLOR_RANGE,vec3(1.0/2.2)),0.0,1.0);

	gl_FragData[0] = vec4(color, spec);
	gl_FragData[1] = vec4(vec3((gr/NUM_SAMPLES)),1.0);
}
