#version 120


/*
		@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
		@##############################################################@	
		@#															  #@
		@#		[][][][][] [][][][][] [][][][][] [][][][][] []   	  #@
		@#		[]	  	       []     []      [] []	     [] []        #@
		@#		[]	 	       []     []      [] []	     [] []  	  #@
		@#		[]		       []     []      [] []	     [] []     	  #@
		@#		[][][][][]     []     []      [] [][][][][] []   	  #@
		@#				[]     []     []      [] []	        []        #@
		@#				[]     []     []      [] []	        []        #@
		@#				[]     []     []      [] []	           		  #@
		@#		[][][][][]     []     [][][][][] []	        []        #@
		@#															  #@
		@##############################################################@
		@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
		
		
		BEFORE DO ANYTHING, READ THIS AGREEMENT FIRST :
		
		
		YOU ARE ALLOWED TO :
		
		- Make videos or pictures with my shaderpack
		- Modify it only for yourself
		- Earn money with it from your YouTube Videos
		- Share my shaderpack link
		
		YOU ARE NOT ALLOWED TO :
		
		- Rename it and claim my shaderpack as your own
		- Publish your modifications
*/

#define MAX_COLOR_RANGE 48.0
/*
!! DO NOT REMOVE !!
Werrus shaders, derived from Chocapic13 V5TEST_FIX1.
This code is from Chocapic13' shaders.
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

/*
Disable an effect by putting "//" before "#define" when there is no number after
You can tweak the numbers, the impact on the shaders is self-explained in the variable's name or in a comment
*/

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
#define VIGNETTE
#define VIGNETTE_STRENGTH 0.72	//default 0.72
#define VIGNETTE_START 0.1		//distance from the center of the screen where the vignette effect start (0-1), default 0.1
#define VIGNETTE_END 0.7		//distance from the center of the screen where the vignette effect end (0-1), bigger than VIGNETTE_START, default 0.7
  
#define SUN_RAYS
#define LENS_FLARE

#define RAIN_DROPS

//tonemapping constants			
float A = 0.4;					//brightness multiplier
float B = 0.1;					//black level (lower means darker and more constrasted, higher make the image whiter and less constrasted)
float C = 0.1;					//constrast level 



//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES



varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;

varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 ambient_color;

varying float eyeAdapt;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;
uniform sampler2D noisetex;
uniform sampler2D gnormal;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux4;
uniform sampler2D composite;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;
vec3 sunPos = sunPosition;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float timefract = worldTime;

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

// Standard depth function.
float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}


#ifdef DOF
	//hexagon pattern
	const vec2 hex_offsets[60] = vec2[60] (	vec2(  0.2165,  0.1250 ),
											vec2(  0.0000,  0.2500 ),
											vec2( -0.2165,  0.1250 ),
											vec2( -0.2165, -0.1250 ),
											vec2( -0.0000, -0.2500 ),
											vec2(  0.2165, -0.1250 ),
											vec2(  0.4330,  0.2500 ),
											vec2(  0.0000,  0.5000 ),
											vec2( -0.4330,  0.2500 ),
											vec2( -0.4330, -0.2500 ),
											vec2( -0.0000, -0.5000 ),
											vec2(  0.4330, -0.2500 ),
											vec2(  0.6495,  0.3750 ),
											vec2(  0.0000,  0.7500 ),
											vec2( -0.6495,  0.3750 ),
											vec2( -0.6495, -0.3750 ),
											vec2( -0.0000, -0.7500 ),
											vec2(  0.6495, -0.3750 ),
											vec2(  0.8660,  0.5000 ),
											vec2(  0.0000,  1.0000 ),
											vec2( -0.8660,  0.5000 ),
											vec2( -0.8660, -0.5000 ),
											vec2( -0.0000, -1.0000 ),
											vec2(  0.8660, -0.5000 ),
											vec2(  0.2163,  0.3754 ),
											vec2( -0.2170,  0.3750 ),
											vec2( -0.4333, -0.0004 ),
											vec2( -0.2163, -0.3754 ),
											vec2(  0.2170, -0.3750 ),
											vec2(  0.4333,  0.0004 ),
											vec2(  0.4328,  0.5004 ),
											vec2( -0.2170,  0.6250 ),
											vec2( -0.6498,  0.1246 ),
											vec2( -0.4328, -0.5004 ),
											vec2(  0.2170, -0.6250 ),
											vec2(  0.6498, -0.1246 ),
											vec2(  0.6493,  0.6254 ),
											vec2( -0.2170,  0.8750 ),
											vec2( -0.8663,  0.2496 ),
											vec2( -0.6493, -0.6254 ),
											vec2(  0.2170, -0.8750 ),
											vec2(  0.8663, -0.2496 ),
											vec2(  0.2160,  0.6259 ),
											vec2( -0.4340,  0.5000 ),
											vec2( -0.6500, -0.1259 ),
											vec2( -0.2160, -0.6259 ),
											vec2(  0.4340, -0.5000 ),
											vec2(  0.6500,  0.1259 ),
											vec2(  0.4325,  0.7509 ),
											vec2( -0.4340,  0.7500 ),
											vec2( -0.8665, -0.0009 ),
											vec2( -0.4325, -0.7509 ),
											vec2(  0.4340, -0.7500 ),
											vec2(  0.8665,  0.0009 ),
											vec2(  0.2158,  0.8763 ),
											vec2( -0.6510,  0.6250 ),
											vec2( -0.8668, -0.2513 ),
											vec2( -0.2158, -0.8763 ),
											vec2(  0.6510, -0.6250 ),
											vec2(  0.8668,  0.2513 ));
											
	const vec2 offsets[60] = vec2[60]  (  vec2( 0.0000, 0.2500 ),
									vec2( -0.2165, 0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2( 0.2165, -0.1250 ),
									vec2( 0.2165, 0.1250 ),
									vec2( 0.0000, 0.5000 ),
									vec2( -0.2500, 0.4330 ),
									vec2( -0.4330, 0.2500 ),
									vec2( -0.5000, 0.0000 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.2500, -0.4330 ),
									vec2( -0.0000, -0.5000 ),
									vec2( 0.2500, -0.4330 ),
									vec2( 0.4330, -0.2500 ),
									vec2( 0.5000, -0.0000 ),
									vec2( 0.4330, 0.2500 ),
									vec2( 0.2500, 0.4330 ),
									vec2( 0.0000, 0.7500 ),
									vec2( -0.2565, 0.7048 ),
									vec2( -0.4821, 0.5745 ),
									vec2( -0.6495, 0.3750 ),
									vec2( -0.7386, 0.1302 ),
									vec2( -0.7386, -0.1302 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.4821, -0.5745 ),
									vec2( -0.2565, -0.7048 ),
									vec2( -0.0000, -0.7500 ),
									vec2( 0.2565, -0.7048 ),
									vec2( 0.4821, -0.5745 ),
									vec2( 0.6495, -0.3750 ),
									vec2( 0.7386, -0.1302 ),
									vec2( 0.7386, 0.1302 ),
									vec2( 0.6495, 0.3750 ),
									vec2( 0.4821, 0.5745 ),
									vec2( 0.2565, 0.7048 ),
									vec2( 0.0000, 1.0000 ),
									vec2( -0.2588, 0.9659 ),
									vec2( -0.5000, 0.8660 ),
									vec2( -0.7071, 0.7071 ),
									vec2( -0.8660, 0.5000 ),
									vec2( -0.9659, 0.2588 ),
									vec2( -1.0000, 0.0000 ),
									vec2( -0.9659, -0.2588 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.7071, -0.7071 ),
									vec2( -0.5000, -0.8660 ),
									vec2( -0.2588, -0.9659 ),
									vec2( -0.0000, -1.0000 ),
									vec2( 0.2588, -0.9659 ),
									vec2( 0.5000, -0.8660 ),
									vec2( 0.7071, -0.7071 ),
									vec2( 0.8660, -0.5000 ),
									vec2( 0.9659, -0.2588 ),
									vec2( 1.0000, -0.0000 ),
									vec2( 0.9659, 0.2588 ),
									vec2( 0.8660, 0.5000 ),
									vec2( 0.7071, 0.7071 ),
									vec2( 0.5000, 0.8660 ),
									vec2( 0.2588, 0.9659 ));
#endif



vec3 Uncharted2Tonemap(vec3 x) {
	float D = 0.2;		
	float E = 0.02;
	float F = 0.3;
	float W = MAX_COLOR_RANGE;
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}

float distratio(vec2 pos, vec2 pos2) {
	float xvect = pos.x*aspectRatio-pos2.x*aspectRatio;
	float yvect = pos.y-pos2.y;
	return sqrt(xvect*xvect + yvect*yvect);
}

float distratio2(vec2 pos, vec2 pos2, float ratio) {
float xvect = pos.x*ratio-pos2.x*ratio;
float yvect = pos.y-pos2.y;
return sqrt(xvect*xvect + yvect*yvect);
}
								
float gen_circular_lens(vec2 center, float size) {
	float dist=distratio(center,texcoord.xy)/size;
	return exp(-dist*dist);
}

float gen_circular_lens2(vec2 center, float size) {
return 1.0-pow(min(distratio2(texcoord.xy,center,aspectRatio),size)/size,10.0);
}

vec2 noisepattern(vec2 pos) {
	return vec2(abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)),abs(fract(sin(dot(pos.yx ,vec2(18.9898f,28.633f))) * 4378.5453f)));
}

float getnoise(vec2 pos) {
	return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

vec2 newtc = texcoord.xy;
float pixeldepth = texture2D(depthtex0,texcoord.xy).x;

vec3 alphablend(vec3 c, vec3 ac, float a) {
vec3 n_ac = normalize(ac)*(1/sqrt(3.));
vec3 nc = sqrt(c*n_ac);
return mix(c,nc,a);
}
float smStep (float edge0,float edge1,float x) {
float t = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
return t * t * (3.0 - 2.0 * t); }

float waterDrop (vec2 tc) {
	vec2 drop = vec2(0.0,fract(frameTimeCounter/750.0));
	tc.x *= 10;
	float noise = texture2D(noisetex,(tc+drop)/2).x;
	noise += texture2D(noisetex,(tc+drop)).x/2;
	noise += texture2D(noisetex,(tc+drop)*2).x/4;
	noise += texture2D(noisetex,(tc+drop)*4).x/8;	
	noise += texture2D(noisetex,(tc+drop*0.5)).x/2;
	noise += texture2D(noisetex,(tc+drop*0.5)*2).x/4;
	noise += texture2D(noisetex,(tc+drop*0.5)*4).x/8;	
	float dropstrength = max(noise-1.8,0.0);
	float wdrop = 0.1;
	float waterD = (1.0 - (pow(wdrop,dropstrength)));
	waterD *= clamp((eyeBrightness.y-220)/15.0,0.0,1.0)*rainStrength;
	float check_enabled = 0.0;
	#ifdef RAIN_DROPS
	check_enabled = 1.0;
	#endif
	return waterD*check_enabled;
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {

	const float pi = 3.14159265359;

	vec2 fake_refract = vec2(sin(frameTimeCounter + texcoord.x*50.0 + texcoord.y*10.0),cos(frameTimeCounter + texcoord.y*50.0 + texcoord.x*10.0)) ;
	vec2 fake_refract2 = vec2(sin(frameTimeCounter*2 + texcoord.x*50.0 + texcoord.y*10.0),cos(frameTimeCounter*2 + texcoord.y*50.0 + texcoord.x*10.0)) ;
	vec2 newTC = texcoord.st + fake_refract * 0.06 * waterDrop(texcoord.xy/300) + fake_refract2 * 0.0025 * isEyeInWater;

	vec3 color = pow(texture2D(gaux2, newTC).rgb,vec3(2.2))*MAX_COLOR_RANGE;

	float fog = 1-(exp(-pow(ld(texture2D(depthtex0, newTC.st).r)/256.0*far,4.0-(2.7*rainStrength))*4.0));

//Bloom
const float rMult = 0.0016;
const int nSteps = 15;


int center = (nSteps-1)/2;
float radius = center*rMult;

vec3 blur = vec3(0.0);
float tw = 0.0;

float sigma = 0.3;
float A = 1.0/sqrt(2.0*3.14159265359*sigma);


for (int i = 0; i < nSteps; i++) {

float dist = (i-float(center))/center;

float weight = A*exp(-(dist*dist)/(2.0*sigma));

blur += pow(texture2DLod(composite,texcoord.xy + (rMult*eyeAdapt)*vec2(1.0,aspectRatio)*vec2(0.0,i-center),2).rgb,vec3(2.2))*weight;

tw += weight;
}
blur /= tw;


color.rgb = mix(color,blur*MAX_COLOR_RANGE,(fog)*min(rainStrength+isEyeInWater,1.));

blur *= 0.2 * (sqrt(luma(blur)));
color.xyz = ((1-(1-color.xyz/48.0)*(1-blur.xyz))*48.0);

/*

color = ((blur + color/MAX_COLOR_RANGE) - (blur * color/MAX_COLOR_RANGE))*MAX_COLOR_RANGE;*/

	//draw rain
	vec4 rain = pow(texture2D(gaux4,newTC.xy)+0.0001,vec4(vec3(2.2),0.4))*vec4(vec3(0.1,0.1,0.1)*(0.4-moonVisibility*0.3),1.0);
	color += alphablend(color,rain.rgb,rain.a);

	
	//Tonemapping
	vec3 curr = Uncharted2Tonemap(color);
	
	vec3 whiteScale = 1.0f/Uncharted2Tonemap(vec3(MAX_COLOR_RANGE));
	color = curr*whiteScale;
	
	
	
		
	#ifdef VIGNETTE
	float len = length(texcoord.xy-vec2(.5));
	float len2 = distratio(texcoord.xy,vec2(.5));
	float dc = mix(len,len2,0.3);
    float vignette = smStep(VIGNETTE_END, VIGNETTE_START,  dc);
	
	color = mix(color,color*vignette,VIGNETTE_STRENGTH);
	#endif


	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos2 = tpos.xy/tpos.z;
	vec2 lightPos = pos2*0.5+0.5;
	float truepos = sunPosition.z/abs(sunPosition.z);		//1 -> sun / -1 -> moon
	const float speed = 10.5;
	float light_jitter = 1.0-sin(frameTimeCounter*100.9*speed+cos(frameTimeCounter*100.9*speed))*0.01;
	
	#ifdef SUN_RAYS

	float xdist = abs(lightPos.x-newTC.x);
	float ydist = abs(lightPos.y-newTC.y);
	float sunvisibility = texture2D(gaux2,vec2(pw,ph)).a*(1-rainStrength*0.9);
	float centerdist = clamp(1.0 - pow(cdist(lightPos), 0.2), 0.0, 1.0);
	vec3 light_color = mix(sunlight*sunVisibility,3*moonlight*moonVisibility,(truepos+1.0)/2.);

		if (sunvisibility > 0.05) {
			vec3 lensColor = exp(-ydist*ydist/0.075/(1.5-centerdist))*exp(-xdist*xdist/0.025/(1.5-centerdist))* vec3(0.0,0.0,0.0);
			if (sunVisibility > 0.1) lensColor += gen_circular_lens(vec2(lightPos),0.24*light_jitter*(1.3-centerdist))*pow(sunvisibility,-0.1)*.2/(centerdist*0.99+0.01);		//sun glare (replace bloom)
			lensColor = lensColor*pow(sunvisibility,2.2)*light_color*3.0*centerdist;
			color += lensColor;
		}
	#endif
	
			float distof = min(min(1.0-lightPos.x,lightPos.x),min(1.0-lightPos.y,lightPos.y));
			float fading = clamp(1.0-step(distof,0.1)+pow(distof*10.0,5.0),0.0,1.0);
	
#ifdef LENS_FLARE

vec3 sP = sunPosition;

			vec2 lPos = lightPos;

			if (fading > 0.01 && TimeMidnight < 1.0) {

			
			float sunmask = 0.0f;
			float sunstep = -4.5f;
			float masksize = 0.004f;

sunmask = texture2D(gaux2,vec2(0.0)).a;
					sunmask *= 0.5*light_jitter* (1.0f - TimeMidnight)*fading;
					sunmask *= 1.0 - rainx;
			if (sunmask > 0.02) {
			//Detect if sun is on edge of screen
				float edgemaskx = clamp(distance(lPos.x, 0.5f)*8.0f - 3.0f, 0.0f, 1.0f);
				float edgemasky = clamp(distance(lPos.y, 0.5f)*8.0f - 3.0f, 0.0f, 1.0f);

				float centermask = 1.0 - clamp(distance(lPos.xy, vec2(0.5f, 0.5f))*2.0, 0.0, 1.0);
						centermask = pow(centermask, 1.0f);
						centermask *= sunmask;

			//Adjust global flare settings
				float flaremultR = 0.8f;
				float flaremultG = 1.0f;
				float flaremultB = 1.5f;

				float flarescale = 1.0f;
				const float flarescaleconst = 1.0f;
			
			
			//Flare gets bigger at center of screen
			
				flarescale *= (0.7 - centermask);

			//Anamorphic lens
			vec2 flare1scale = vec2(0.2f*flarescale, 4.7f*flarescale);
			float flare1pow = 12.0f;
			vec2 flare1pos = vec2(lPos.x*aspectRatio*flare1scale.x, lPos.y*flare1scale.y);
			
			
			float flare1 = distance(flare1pos, vec2(texcoord.s*aspectRatio*flare1scale.x, texcoord.t*flare1scale.y));
				  flare1 = 0.5 - flare1;
				  flare1 = clamp(flare1, 0.0, 10.0) * clamp(-sP.z, 0.0, 1.0);
				  flare1 *= sunmask;
				  flare1 = pow(flare1, 1.8f);
				  
				  flare1 *= flare1pow;
				  
				  	color.r += flare1*0.1f*flaremultR;
					color.g += flare1*0.6f*flaremultG;
					color.b += flare1*0.8f*flaremultB;	
				
			//Wide red flare
			vec2 flare2pos = vec2(lPos.x*aspectRatio*0.2, lPos.y);
			
			float flare2 = distance(flare2pos, vec2(texcoord.s*aspectRatio*0.2, texcoord.t));
				  flare2 = 0.3 - flare2;
				  flare2 = clamp(flare2, 0.0, 10.0) * clamp(-sP.z, 0.0, 1.0);
				  flare2 *= sunmask;
				  flare2 = pow(flare2, 1.8f);
				  	
					color.r += flare2*1.0f*flaremultR;
					color.g += flare2*0.3f*flaremultG;
					color.b += flare2*0.1f*flaremultB;
					
					
					
			//Wide red flare
			vec2 flare2posB = vec2(lPos.x*aspectRatio*0.2, lPos.y*4.0);
			
			float flare2B = distance(flare2posB, vec2(texcoord.s*aspectRatio*0.2, texcoord.t*4.0));
				  flare2B = 0.3 - flare2B;
				  flare2B = clamp(flare2B, 0.0, 10.0) * clamp(-sP.z, 0.0, 1.0);
				  flare2B *= sunmask;
				  flare2B = pow(flare2B, 1.8f);
				  	
					color.r += flare2B*0.8f*flaremultR;
					color.g += flare2B*0.6f*flaremultG;
					color.b += flare2B*0.1f*flaremultB;
					
					
					
			//Far blue flare MAIN
			  vec2 flare3scale = vec2(2.0f*flarescale, 2.0f*flarescale);
			  float flare3pow = 0.7f;
			  float flare3fill = 10.0f;
			  float flare3offset = -0.5f;
			vec2 flare3pos = vec2(  ((1.0 - lPos.x)*(flare3offset + 1.0) - (flare3offset*0.5))  *aspectRatio*flare3scale.x,  ((1.0 - lPos.y)*(flare3offset + 1.0) - (flare3offset*0.5))  *flare3scale.y);
			
			
			float flare3 = distance(flare3pos, vec2(texcoord.s*aspectRatio*flare3scale.x, texcoord.t*flare3scale.y));
				  flare3 = 0.5 - flare3;
				  flare3 = clamp(flare3*flare3fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare3 = sin(flare3*1.57075);
				  flare3 *= sunmask;
				  flare3 = pow(flare3, 1.1f);
				  
				  flare3 *= flare3pow;			
				  
				  
				  //subtract from blue flare
				  vec2 flare3Bscale = vec2(1.4f*flarescale, 1.4f*flarescale);
				  float flare3Bpow = 1.0f;
				  float flare3Bfill = 2.0f;
				  float flare3Boffset = -0.65f;
				vec2 flare3Bpos = vec2(  ((1.0 - lPos.x)*(flare3Boffset + 1.0) - (flare3Boffset*0.5))  *aspectRatio*flare3Bscale.x,  ((1.0 - lPos.y)*(flare3Boffset + 1.0) - (flare3Boffset*0.5))  *flare3Bscale.y);
			
			
				float flare3B = distance(flare3Bpos, vec2(texcoord.s*aspectRatio*flare3Bscale.x, texcoord.t*flare3Bscale.y));
					flare3B = 0.5 - flare3B;
					flare3B = clamp(flare3B*flare3Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
					flare3B = sin(flare3B*1.57075);
					flare3B *= sunmask;
					flare3B = pow(flare3B, 0.9f);
				  
					flare3B *= flare3Bpow;
				  
				flare3 = clamp(flare3 - flare3B, 0.0, 10.0);
				  
				  
				  	color.r += flare3*0.1f*flaremultR;
					color.g += flare3*1.0f*flaremultG;
					color.b += flare3*0.3f*flaremultB;

					
					
					
			//Far blue flare MAIN 2
			  vec2 flare3Cscale = vec2(3.2f*flarescale, 3.2f*flarescale);
			  float flare3Cpow = 1.4f;
			  float flare3Cfill = 10.0f;
			  float flare3Coffset = -0.0f;
			vec2 flare3Cpos = vec2(  ((1.0 - lPos.x)*(flare3Coffset + 1.0) - (flare3Coffset*0.5))  *aspectRatio*flare3Cscale.x,  ((1.0 - lPos.y)*(flare3Coffset + 1.0) - (flare3Coffset*0.5))  *flare3Cscale.y);
			
			
			float flare3C = distance(flare3Cpos, vec2(texcoord.s*aspectRatio*flare3Cscale.x, texcoord.t*flare3Cscale.y));
				  flare3C = 0.5 - flare3C;
				  flare3C = clamp(flare3C*flare3Cfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare3C = sin(flare3C*1.57075);
				  
				  flare3C = pow(flare3C, 1.1f);
				  
				  flare3C *= flare3Cpow;			
				  
				  
				  //subtract from blue flare
				  vec2 flare3Dscale = vec2(2.2f*flarescale, 2.2f*flarescale);
				  float flare3Dpow = 2.7f;
				  float flare3Dfill = 1.4f;
				  float flare3Doffset = -0.2f;
				vec2 flare3Dpos = vec2(  ((1.0 - lPos.x)*(flare3Doffset + 1.0) - (flare3Doffset*0.5))  *aspectRatio*flare3Dscale.x,  ((1.0 - lPos.y)*(flare3Doffset + 1.0) - (flare3Doffset*0.5))  *flare3Dscale.y);
			
			
				float flare3D = distance(flare3Dpos, vec2(texcoord.s*aspectRatio*flare3Dscale.x, texcoord.t*flare3Dscale.y));
					flare3D = 0.5 - flare3D;
					flare3D = clamp(flare3D*flare3Dfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
					flare3D = sin(flare3D*1.57075);
					flare3D = pow(flare3D, 0.9f);
				  
					flare3D *= flare3Dpow;
				  
				flare3C = clamp(flare3C - flare3D, 0.0, 10.0);
				flare3C *= sunmask;
				  
				  	color.r += flare3C*0.1f*flaremultR;
					color.g += flare3C*0.6f*flaremultG;
					color.b += flare3C*0.8f*flaremultB;							
					
					
					
					
					
					
					
					
					
			//far small pink flare
			  vec2 flare4scale = vec2(4.5f*flarescale, 4.5f*flarescale);
			  float flare4pow = 0.3f;
			  float flare4fill = 3.0f;
			  float flare4offset = -0.1f;
			vec2 flare4pos = vec2(  ((1.0 - lPos.x)*(flare4offset + 1.0) - (flare4offset*0.5))  *aspectRatio*flare4scale.x,  ((1.0 - lPos.y)*(flare4offset + 1.0) - (flare4offset*0.5))  *flare4scale.y);
			
			
			float flare4 = distance(flare4pos, vec2(texcoord.s*aspectRatio*flare4scale.x, texcoord.t*flare4scale.y));
				  flare4 = 0.5 - flare4;
				  flare4 = clamp(flare4*flare4fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4 = sin(flare4*1.57075);
				  flare4 *= sunmask;
				  flare4 = pow(flare4, 1.1f);
				  
				  flare4 *= flare4pow;
				  
				  	color.r += flare4*1.0f*flaremultR;
					color.g += flare4*0.3f*flaremultG;
					color.b += flare4*0.1f*flaremultB;							
					
					
					
			//far small pink flare2
			  vec2 flare4Bscale = vec2(7.5f*flarescale, 7.5f*flarescale);
			  float flare4Bpow = 0.4f;
			  float flare4Bfill = 2.0f;
			  float flare4Boffset = 0.0f;
			vec2 flare4Bpos = vec2(  ((1.0 - lPos.x)*(flare4Boffset + 1.0) - (flare4Boffset*0.5))  *aspectRatio*flare4Bscale.x,  ((1.0 - lPos.y)*(flare4Boffset + 1.0) - (flare4Boffset*0.5))  *flare4Bscale.y);
			
			
			float flare4B = distance(flare4Bpos, vec2(texcoord.s*aspectRatio*flare4Bscale.x, texcoord.t*flare4Bscale.y));
				  flare4B = 0.5 - flare4B;
				  flare4B = clamp(flare4B*flare4Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4B = sin(flare4B*1.57075);
				  flare4B *= sunmask;
				  flare4B = pow(flare4B, 1.1f);
				  
				  flare4B *= flare4Bpow;
				  
				  	color.r += flare4B*0.8f*flaremultR;
					color.g += flare4B*0.6f*flaremultG;
					color.b += flare4B*0.1f*flaremultB;						
					
					
					
			//far small pink flare3
			  vec2 flare4Cscale = vec2(37.5f*flarescale, 37.5f*flarescale);
			  float flare4Cpow = 2.0f;
			  float flare4Cfill = 2.0f;
			  float flare4Coffset = -0.3f;
			vec2 flare4Cpos = vec2(  ((1.0 - lPos.x)*(flare4Coffset + 1.0) - (flare4Coffset*0.5))  *aspectRatio*flare4Cscale.x,  ((1.0 - lPos.y)*(flare4Coffset + 1.0) - (flare4Coffset*0.5))  *flare4Cscale.y);
			
			
			float flare4C = distance(flare4Cpos, vec2(texcoord.s*aspectRatio*flare4Cscale.x, texcoord.t*flare4Cscale.y));
				  flare4C = 0.5 - flare4C;
				  flare4C = clamp(flare4C*flare4Cfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4C = sin(flare4C*1.57075);
				  flare4C *= sunmask;
				  flare4C = pow(flare4C, 1.1f);
				  
				  flare4C *= flare4Cpow;
				  
				  	color.r += flare4C*0.1f*flaremultR;
					color.g += flare4C*1.0f*flaremultG;
					color.b += flare4C*0.3f*flaremultB;						
					
					
					
			//far small pink flare4
			  vec2 flare4Dscale = vec2(67.5f*flarescale, 67.5f*flarescale);
			  float flare4Dpow = 1.0f;
			  float flare4Dfill = 2.0f;
			  float flare4Doffset = -0.35f;
			vec2 flare4Dpos = vec2(  ((1.0 - lPos.x)*(flare4Doffset + 1.0) - (flare4Doffset*0.5))  *aspectRatio*flare4Dscale.x,  ((1.0 - lPos.y)*(flare4Doffset + 1.0) - (flare4Doffset*0.5))  *flare4Dscale.y);
			
			
			float flare4D = distance(flare4Dpos, vec2(texcoord.s*aspectRatio*flare4Dscale.x, texcoord.t*flare4Dscale.y));
				  flare4D = 0.5 - flare4D;
				  flare4D = clamp(flare4D*flare4Dfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4D = sin(flare4D*1.57075);
				  flare4D *= sunmask;
				  flare4D = pow(flare4D, 1.1f);
				  
				  flare4D *= flare4Dpow;
				  
				  	color.r += flare4D*0.1f*flaremultR;
					color.g += flare4D*0.6f*flaremultG;
					color.b += flare4D*0.8f*flaremultB;						
					
					
								
			//far small pink flare5
			  vec2 flare4Escale = vec2(60.5f*flarescale, 60.5f*flarescale);
			  float flare4Epow = 1.0f;
			  float flare4Efill = 3.0f;
			  float flare4Eoffset = -0.3393f;
			vec2 flare4Epos = vec2(  ((1.0 - lPos.x)*(flare4Eoffset + 1.0) - (flare4Eoffset*0.5))  *aspectRatio*flare4Escale.x,  ((1.0 - lPos.y)*(flare4Eoffset + 1.0) - (flare4Eoffset*0.5))  *flare4Escale.y);
			
			
			float flare4E = distance(flare4Epos, vec2(texcoord.s*aspectRatio*flare4Escale.x, texcoord.t*flare4Escale.y));
				  flare4E = 0.5 - flare4E;
				  flare4E = clamp(flare4E*flare4Efill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4E = sin(flare4E*1.57075);
				  flare4E *= sunmask;
				  flare4E = pow(flare4E, 1.1f);
				  
				  flare4E *= flare4Epow;
				  
				  	color.r += flare4E*1.0f*flaremultR;
					color.g += flare4E*0.3f*flaremultG;
					color.b += flare4E*0.1f*flaremultB;					
					
								
								
			//far small pink flare5
			  vec2 flare4Fscale = vec2(20.5f*flarescale, 20.5f*flarescale);
			  float flare4Fpow = 3.0f;
			  float flare4Ffill = 3.0f;
			  float flare4Foffset = -0.4713f;
			vec2 flare4Fpos = vec2(  ((1.0 - lPos.x)*(flare4Foffset + 1.0) - (flare4Foffset*0.5))  *aspectRatio*flare4Fscale.x,  ((1.0 - lPos.y)*(flare4Foffset + 1.0) - (flare4Foffset*0.5))  *flare4Fscale.y);
			
			
			float flare4F = distance(flare4Fpos, vec2(texcoord.s*aspectRatio*flare4Fscale.x, texcoord.t*flare4Fscale.y));
				  flare4F = 0.5 - flare4F;
				  flare4F = clamp(flare4F*flare4Ffill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare4F = sin(flare4F*1.57075);
				  flare4F *= sunmask;
				  flare4F = pow(flare4F, 1.1f);
				  
				  flare4F *= flare4Fpow;
				  
				  	color.r += flare4F*0.8f*flaremultR;
					color.g += flare4F*0.6f*flaremultG;
					color.b += flare4F*0.1f*flaremultB;						
					
					
					
					
					
					
					
					
					
					
					
					
			//
			  vec2 flare5scale = vec2(3.2f*flarescale , 3.2f*flarescale );
			  float flare5pow = 13.4f;
			  float flare5fill = 1.0f;
			  float flare5offset = -2.0f;
			vec2 flare5pos = vec2(  ((1.0 - lPos.x)*(flare5offset + 1.0) - (flare5offset*0.5))  *aspectRatio*flare5scale.x,  ((1.0 - lPos.y)*(flare5offset + 1.0) - (flare5offset*0.5))  *flare5scale.y);
			
			
			float flare5 = distance(flare5pos, vec2(texcoord.s*aspectRatio*flare5scale.x, texcoord.t*flare5scale.y));
				  flare5 = 0.5 - flare5;
				  flare5 = clamp(flare5*flare5fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare5 *= sunmask;
				  flare5 = pow(flare5, 1.9f);
				  
				  flare5 *= flare5pow;
				  
				  	color.r += flare5*0.1f*flaremultR;
					color.g += flare5*1.0f*flaremultG;
					color.b += flare5*0.3f*flaremultB;						
					
					
					
					
					
			//close ring flare red
			  vec2 flare6scale = vec2(2.1f*flarescale, 2.1f*flarescale);
			  float flare6pow = 0.2f;
			  float flare6fill = 5.0f;
			  float flare6offset = -1.9f;
			vec2 flare6pos = vec2(  ((1.0 - lPos.x)*(flare6offset + 1.0) - (flare6offset*0.5))  *aspectRatio*flare6scale.x,  ((1.0 - lPos.y)*(flare6offset + 1.0) - (flare6offset*0.5))  *flare6scale.y);
			
			
			float flare6 = distance(flare6pos, vec2(texcoord.s*aspectRatio*flare6scale.x, texcoord.t*flare6scale.y));
				  flare6 = 0.5 - flare6;
				  flare6 = clamp(flare6*flare6fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare6 = pow(flare6, 1.6f);
				  flare6 = sin(flare6*3.1415);
				  flare6 *= sunmask;

				  
				  flare6 *= flare6pow;
				  
				  	color.r += flare6*0.8f*flaremultR;
					color.g += flare6*0.6f*flaremultG;
					color.b += flare6*0.1f*flaremultB;						
					
					
					
			//close ring flare green
			  vec2 flare6Bscale = vec2(2.0f*flarescale, 2.0f*flarescale);
			  float flare6Bpow = 0.2f;
			  float flare6Bfill = 5.0f;
			  float flare6Boffset = -1.9f;
			vec2 flare6Bpos = vec2(  ((1.0 - lPos.x)*(flare6Boffset + 1.0) - (flare6Boffset*0.5))  *aspectRatio*flare6Bscale.x,  ((1.0 - lPos.y)*(flare6Boffset + 1.0) - (flare6Boffset*0.5))  *flare6Bscale.y);
			
			
			float flare6B = distance(flare6Bpos, vec2(texcoord.s*aspectRatio*flare6Bscale.x, texcoord.t*flare6Bscale.y));
				  flare6B = 0.5 - flare6B;
				  flare6B = clamp(flare6B*flare6Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare6B = pow(flare6B, 1.6f);
				  flare6B = sin(flare6B*3.1415);
				  flare6B *= sunmask;

				  
				  flare6B *= flare6Bpow;
				  
				  	color.r += flare6B*0.1f*flaremultR;
					color.g += flare6B*1.0f*flaremultG;
					color.b += flare6B*0.3f*flaremultB;						
					
					
			
			//close ring flare blue
			  vec2 flare6Cscale = vec2(1.8f*flarescale, 1.8f*flarescale);
			  float flare6Cpow = 0.2f;
			  float flare6Cfill = 5.0f;
			  float flare6Coffset = -1.9f;
			vec2 flare6Cpos = vec2(  ((1.0 - lPos.x)*(flare6Coffset + 1.0) - (flare6Coffset*0.5))  *aspectRatio*flare6Cscale.x,  ((1.0 - lPos.y)*(flare6Coffset + 1.0) - (flare6Coffset*0.5))  *flare6Cscale.y);
			
			
			float flare6C = distance(flare6Cpos, vec2(texcoord.s*aspectRatio*flare6Cscale.x, texcoord.t*flare6Cscale.y));
				  flare6C = 0.5 - flare6C;
				  flare6C = clamp(flare6C*flare6Cfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare6C = pow(flare6C, 1.8f);
				  flare6C = sin(flare6C*3.1415);
				  flare6C *= sunmask;

				  
				  flare6C *= flare6Cpow;
				  
				  	color.r += flare6C*0.1f*flaremultR;
					color.g += flare6C*0.6f*flaremultG;
					color.b += flare6C*0.8f*flaremultB;						

			//far red glow

			  vec2 flare7Bscale = vec2(0.4f*flarescale, 0.4f*flarescale);
			  float flare7Bpow = 0.1f;
			  float flare7Bfill = 2.0f;
			  float flare7Boffset = 2.9f;
			vec2 flare7Bpos = vec2(  ((1.0 - lPos.x)*(flare7Boffset + 1.0) - (flare7Boffset*0.5))  *aspectRatio*flare7Bscale.x,  ((1.0 - lPos.y)*(flare7Boffset + 1.0) - (flare7Boffset*0.5))  *flare7Bscale.y);
			
			
			float flare7B = distance(flare7Bpos, vec2(texcoord.s*aspectRatio*flare7Bscale.x, texcoord.t*flare7Bscale.y));
				  flare7B = 0.5 - flare7B;
				  flare7B = clamp(flare7B*flare7Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare7B = pow(flare7B, 1.9f);
				  flare7B = sin(flare7B*3.1415*0.5);
				  flare7B *= sunmask;

				  
				  flare7B *= flare7Bpow;
				  
				  	color.r += flare7B*0.1f*flaremultR;
					color.g += flare7B*1.0f*flaremultG;
					color.b += flare7B*0.3f*flaremultB;	
			
			
			
		
					
					
					
		//SMALL SWEEPS		///////////////////////////////						
					
					
			//mid orange sweep
			  vec2 flare10scale = vec2(6.0f*flarescale, 6.0f*flarescale);
			  float flare10pow = 1.9f;
			  float flare10fill = 1.1f;
			  float flare10offset = -0.7f;
			vec2 flare10pos = vec2(  ((1.0 - lPos.x)*(flare10offset + 1.0) - (flare10offset*0.5))  *aspectRatio*flare10scale.x,  ((1.0 - lPos.y)*(flare10offset + 1.0) - (flare10offset*0.5))  *flare10scale.y);
			
			
			float flare10 = distance(flare10pos, vec2(texcoord.s*aspectRatio*flare10scale.x, texcoord.t*flare10scale.y));
				  flare10 = 0.5 - flare10;
				  flare10 = clamp(flare10*flare10fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare10 = sin(flare10*1.57075);
				  flare10 *= sunmask;
				  flare10 = pow(flare10, 1.1f);
				  
				  flare10 *= flare10pow;			
				  
				  
				  //subtract
				  vec2 flare10Bscale = vec2(5.1f*flarescale, 5.1f*flarescale);
				  float flare10Bpow = 1.5f;
				  float flare10Bfill = 1.0f;
				  float flare10Boffset = -0.77f;
				vec2 flare10Bpos = vec2(  ((1.0 - lPos.x)*(flare10Boffset + 1.0) - (flare10Boffset*0.5))  *aspectRatio*flare10Bscale.x,  ((1.0 - lPos.y)*(flare10Boffset + 1.0) - (flare10Boffset*0.5))  *flare10Bscale.y);
			
			
				float flare10B = distance(flare10Bpos, vec2(texcoord.s*aspectRatio*flare10Bscale.x, texcoord.t*flare10Bscale.y));
					flare10B = 0.5 - flare10B;
					flare10B = clamp(flare10B*flare10Bfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
					flare10B = sin(flare10B*1.57075);
					flare10B *= sunmask;
					flare10B = pow(flare10B, 0.9f);
				  
					flare10B *= flare10Bpow;
				  
				flare10 = clamp(flare10 - flare10B, 0.0, 10.0);
				  
				  
				  	color.r += flare10*0.1f*flaremultR;
					color.g += flare10*1.0f*flaremultG;
					color.b += flare10*0.3f*flaremultB;				
					
					
			//mid blue sweep
			  vec2 flare10Cscale = vec2(6.0f*flarescale, 6.0f*flarescale);
			  float flare10Cpow = 1.9f;
			  float flare10Cfill = 1.1f;
			  float flare10Coffset = -0.6f;
			vec2 flare10Cpos = vec2(  ((1.0 - lPos.x)*(flare10Coffset + 1.0) - (flare10Coffset*0.5))  *aspectRatio*flare10Cscale.x,  ((1.0 - lPos.y)*(flare10Coffset + 1.0) - (flare10Coffset*0.5))  *flare10Cscale.y);
			
			
			float flare10C = distance(flare10Cpos, vec2(texcoord.s*aspectRatio*flare10Cscale.x, texcoord.t*flare10Cscale.y));
				  flare10C = 0.5 - flare10C;
				  flare10C = clamp(flare10C*flare10Cfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare10C = sin(flare10C*1.57075);
				  flare10C *= sunmask;
				  flare10C = pow(flare10C, 1.1f);
				  
				  flare10C *= flare10Cpow;			
				  
				  
				  //subtract
				  vec2 flare10Dscale = vec2(5.1f*flarescale, 5.1f*flarescale);
				  float flare10Dpow = 1.5f;
				  float flare10Dfill = 1.0f;
				  float flare10Doffset = -0.67f;
				vec2 flare10Dpos = vec2(  ((1.0 - lPos.x)*(flare10Doffset + 1.0) - (flare10Doffset*0.5))  *aspectRatio*flare10Dscale.x,  ((1.0 - lPos.y)*(flare10Doffset + 1.0) - (flare10Doffset*0.5))  *flare10Dscale.y);
			
			
				float flare10D = distance(flare10Dpos, vec2(texcoord.s*aspectRatio*flare10Dscale.x, texcoord.t*flare10Dscale.y));
					flare10D = 0.5 - flare10D;
					flare10D = clamp(flare10D*flare10Dfill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
					flare10D = sin(flare10D*1.57075);
					flare10D *= sunmask;
					flare10D = pow(flare10D, 0.9f);
				  
					flare10D *= flare10Dpow;
				  
				flare10C = clamp(flare10C - flare10D, 0.0, 10.0);
				  
				  
				  	color.r += flare10C*0.1f*flaremultR;
					color.g += flare10C*0.6f*flaremultG;
					color.b += flare10C*0.8f*flaremultB;	
		//////////////////////////////////////////////////////////
		
		
		
		
		
		//Pointy fuzzy glow dots////////////////////////////////////////////////
			//RedGlow1

			  vec2 flare11scale = vec2(1.5f*flarescale, 1.5f*flarescale);
			  float flare11pow = 1.1f;
			  float flare11fill = 2.0f;
			  float flare11offset = -0.523f;
			vec2 flare11pos = vec2(  ((1.0 - lPos.x)*(flare11offset + 1.0) - (flare11offset*0.5))  *aspectRatio*flare11scale.x,  ((1.0 - lPos.y)*(flare11offset + 1.0) - (flare11offset*0.5))  *flare11scale.y);
			
			
			float flare11 = distance(flare11pos, vec2(texcoord.s*aspectRatio*flare11scale.x, texcoord.t*flare11scale.y));
				  flare11 = 0.5 - flare11;
				  flare11 = clamp(flare11*flare11fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare11 = pow(flare11, 2.9f);
				  flare11 *= sunmask;

				  
				  flare11 *= flare11pow;
				  
				  	color.r += flare11*1.0f*flaremultR;
					color.g += flare11*0.3f*flaremultG;
					color.b += flare11*0.1f*flaremultB;		
					
					
			//PurpleGlow2

			  vec2 flare12scale = vec2(2.5f*flarescale, 2.5f*flarescale);
			  float flare12pow = 0.5f;
			  float flare12fill = 2.0f;
			  float flare12offset = -0.323f;
			vec2 flare12pos = vec2(  ((1.0 - lPos.x)*(flare12offset + 1.0) - (flare12offset*0.5))  *aspectRatio*flare12scale.x,  ((1.0 - lPos.y)*(flare12offset + 1.0) - (flare12offset*0.5))  *flare12scale.y);
			
			
			float flare12 = distance(flare12pos, vec2(texcoord.s*aspectRatio*flare12scale.x, texcoord.t*flare12scale.y));
				  flare12 = 0.5 - flare12;
				  flare12 = clamp(flare12*flare12fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare12 = pow(flare12, 2.9f);
				  flare12 *= sunmask;

				  
				  flare12 *= flare12pow;
				  
				  	color.r += flare12*0.8f*flaremultR;
					color.g += flare12*0.6f*flaremultG;
					color.b += flare12*0.1f*flaremultB;		
					
					
					
			//BlueGlow3

			  vec2 flare13scale = vec2(1.0f*flarescale, 1.0f*flarescale);
			  float flare13pow = 0.5f;
			  float flare13fill = 2.0f;
			  float flare13offset = +0.138f;
			vec2 flare13pos = vec2(  ((1.0 - lPos.x)*(flare13offset + 1.0) - (flare13offset*0.5))  *aspectRatio*flare13scale.x,  ((1.0 - lPos.y)*(flare13offset + 1.0) - (flare13offset*0.5))  *flare13scale.y);
			
			
			float flare13 = distance(flare13pos, vec2(texcoord.s*aspectRatio*flare13scale.x, texcoord.t*flare13scale.y));
				  flare13 = 0.5 - flare13;
				  flare13 = clamp(flare13*flare13fill, 0.0, 1.0) * clamp(-sP.z, 0.0, 1.0);
				  flare13 = pow(flare13, 2.9f);
				  flare13 *= sunmask;

				  
				  flare13 *= flare13pow;
				  
				  	color.r += flare13*0.1f*flaremultR;
					color.g += flare13*1.0f*flaremultG;
					color.b += flare13*0.3f*flaremultB;		
					
			
			color = clamp(color, 0.0, 4.0);
			}
}

#endif

	color = clamp(pow(color,vec3(1.0/2.2)),0.0,1.0);

	
	gl_FragColor = vec4(color,1.0);
}
